﻿// (c) Copyright 2020.  Adobe Systems, Incorporated.  All rights reserved.

// This JavaScript is to be read by Bridge, InCopy, and other Adobe apps at
// launch. It implements the CrossDOM for InCopy

/*
@@@BUILDINFO@@@ incopy-16.0.jsx 16.0.0.0
*/

/*
@@@START_XML@@@
<?xml version="1.0" encoding="UTF-8"?>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="en_US">
     <dc:title>Adobe InCopy CC 2021</dc:title>
     <dc:description>This script enables other applications to communicate with Adobe InCopy CC 2021.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="fr_FR">
     <dc:title>Adobe InCopy CC 2021</dc:title>
     <dc:description>Ce script permet à d'autres applications de communiquer avec Adobe InCopy CC 2021.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="ja_JP">
     <dc:title>Adobe InCopy CC 2021</dc:title>
     <dc:description>このスクリプトは、他のアプリケーションと Adobe InCopy CC 2021 との通信を有効にします。</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="de_DE">
     <dc:title>Adobe InCopy CC 2021</dc:title>
     <dc:description>Mithilfe dieses Skripts können andere Anwendungen mit Adobe InCopy CC 2021 kommunizieren.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="it_IT">
     <dc:title>Adobe InCopy CC 2021</dc:title>
     <dc:description>Questo script consente ad altre applicazioni di comunicare con Adobe InCopy CC 2021</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="es_ES">
     <dc:title>Adobe InCopy CC 2021</dc:title>
     <dc:description>Este script posibilita que otras aplicaciones se comuniquen con Adobe InCopy CC 2021</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="nl_NL">
     <dc:title>Adobe InCopy CC 2021</dc:title>
     <dc:description>Dit script laat andere toepassingen toe te communiceren met Adobe InCopy CC 2021</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="pt_BR">
     <dc:title>Adobe InCopy CC 2021</dc:title>
     <dc:description>Este script permite que outros aplicativos se comuniquem com o Adobe InCopy CC 2021</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="nb_NO">
     <dc:title>Adobe InCopy CC 2021</dc:title>
     <dc:description>Skriptet gjør at andre programmer kan kommunisere med Adobe InCopy CC 2021</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="da_DK">
     <dc:title>Adobe InCopy CC 2021</dc:title>
     <dc:description>Dette script betyder, at andre programmer kan kommunikere med Adobe InCopy CC 2021</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="fi_FI">
     <dc:title>Adobe InCopy CC 2021</dc:title>
     <dc:description>Tämän komentosarjan avulla muut sovellukset ja Adobe InCopy CC 2021 voivat kommunikoida keskenään</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="sv_SE">
     <dc:title>Adobe InCopy CC 2021</dc:title>
     <dc:description>Det här skriptet gör det möjligt för andra program att kommunicera med Adobe InCopy CC 2021</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="zh_TW">
     <dc:title>Adobe InCopy CC 2021</dc:title>
     <dc:description>此指令碼能讓其他應用程式與 Adobe InCopy CC 2021 進行通訊。</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="zh_CN">
     <dc:title>Adobe InCopy CC 2021</dc:title>
     <dc:description>此脚本使其它应用程序能够与 Adobe InCopy CC 2021 进行通信</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="ko_KR">
     <dc:title>Adobe InCopy CC 2021</dc:title>
     <dc:description>이 스크립트를 사용하면 다른 응용 프로그램에서 Adobe InCopy CC 2021과(와) 통신할 수 있습니다.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="cs_CZ">
     <dc:title>Adobe InCopy CC 2021</dc:title>
     <dc:description>Tento skript umožňuje ostatním aplikacím komunikovat s aplikací Adobe InCopy CC 2021.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="pl_PL">
     <dc:title>Adobe InCopy CC 2021</dc:title>
     <dc:description>Ten skrypt umożliwia innym aplikacjom komunikowanie się z programem Adobe InCopy CC 2021.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="hu_HU">
     <dc:title>Adobe InCopy CC 2021</dc:title>
     <dc:description>Ez a szkript lehetővé teszi más alkalmazások számára, hogy kommunikáljanak az Adobe InCopy CC 2021 programmal. </dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="ru_RU">
     <dc:title>Adobe InCopy CC 2021</dc:title>
     <dc:description>Этот сценарий позволяет другим приложениям осуществлять связь с Adobe InCopy CC 2021.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="tr_TR">
     <dc:title>Adobe InCopy CC 2021</dc:title>
     <dc:description>Bu komut dosyası diğer uygulamaların Adobe InCopy CC 2021 ile iletişim kurmasını sağlar.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="uk_UA">
     <dc:title>Adobe InCopy CC 2021</dc:title>
     <dc:description>Цей сценарій активує зв'язок інших програм з Adobe InCopy CC 2021.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="ar_AE">
     <dc:title>Adobe InCopy CC 2021</dc:title>
     <dc:description>يتيح هذا النص التنفيذي للتطبيقات الأخرى أن تتصل بـ Adobe InCopy CC 2021.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="he_IL">
     <dc:title>Adobe InCopy CC 2021</dc:title>
     <dc:description>סקריפט זה מאפשר ליישומים אחרים לתקשר עם Adobe InCopy CC 2021.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="el_GR">
     <dc:title>Adobe InCopy CC 2021</dc:title>
     <dc:description>Αυτή η δέσμη ενεργειών δίνει τη δυνατότητα σε άλλες εφαρμογές να επικοινωνούν με το Adobe InCopy CC 2021.</dc:description>
</ScriptInfo>
@@@END_XML@@@
*/


// debug level: 0-2 (0:disable, 1:break on error, 2:break at beginning)
// $.level = 1;
// debugger; // launch debugger on next line
//=================================================================

//alert("\"" + BridgeTalk.appName + "\" is loading: incopy-16.0.jsx");

var incopy16 = {};

incopy16.createInCTestMenuInBridgeApp = false;	// Set to true to see InC CrossDOM test menu

// Some global strings (scoped to avoid collisions)
incopy16.bridgeTargetName = 					"bridge";
incopy16.inDesignTargetName = 				"indesign";
incopy16.inCopyTargetName =					"incopy";
incopy16.inCopyVersionedTargetName =		"incopy-16";
incopy16.inDesignServerTargetName =			"indesignserver";

incopy16.bridgeAppName = 					"bridge";
incopy16.inDesignAppName = 					"indesign";
incopy16.inCopyAppName = 					"incopy";
incopy16.inDesignServerAppName =				"indesignserver";

incopy16.versionID = 						16.0;
incopy16.targetName = 						"incopy";

incopy16.strings4PlaceMenu=[
		/*00*/ "$$$/extendscript/incopy/Menu/Place/InInCopy=In InCopy",
		/*01*/ "$$$/extendscript/incopy/Error/NoOpenDocForPlaceError=Scripted place (incopy.place) requires an active document window."
];

//=================================================================
// CrossDOM/X-DOM
// Implements InCopy's cross DOM API - the a small set of
// operations that are common to all Adobe apps.
//=================================================================

//=======================================================
//	quit() 
//	- Performs the equivalent of File->Exit or File->Close.
//
//	return value
//		undefined
//=======================================================
incopy16.quit = function ( )
{
	if( BridgeTalk.appName == incopy16.inCopyTargetName )
	{
		incopy16.validateScriptVersion(); //Make sure we're using an appropriate version of the DOM

		app.quit();
	}
	else
	{
		// Create a new BridgeTalk message for InCopy to invoke Quit
		var btMessage = new BridgeTalk;
		btMessage.target = incopy16.inCopyVersionedTargetName;
		btMessage.body = "incopy16.quit();";
		var result = btMessage.send();
	}
}

//=======================================================
//	activate
//	- Activate InCopy (not part of cross DOM)
//=======================================================
incopy16.activate = function ( )
{
	if( BridgeTalk.appName == incopy16.inCopyTargetName )
	{
		incopy16.validateScriptVersion(); //Make sure we're using an appropriate version of the DOM

		app.activate();
	}
	else
	{
		// Create a new BridgeTalk message for InCopy to invoke Activate
		var btMessage = new BridgeTalk;
		btMessage.target = incopy16.inCopyVersionedTargetName;
		btMessage.body = "incopy16.activate();";
		var result = btMessage.send();
	}
}

//=======================================================
//	open( files ) 
//	- Performs the equivalent of File->Open on the requested files. 
//	Accepts either an Array object or a single path.
//	
//	return value						undefined
//
//	files										File or Array of File	files to display in new Window
//=======================================================
incopy16.open = function ( /*list of*/ files )
{
	if( BridgeTalk.appName == incopy16.inCopyTargetName )
	{
		
		incopy16.validateScriptVersion(); //Make sure we're using an appropriate version of the DOM

		app.activate();	// Activate to be sure any dialogs or alerts resulting from the open can be seen by the user.

		var fileArray = incopy16.extractFileArray ( files ); 

		for ( index = 0; index < fileArray.length; ++index )
		{
			var file = fileArray[index];
			
			app.open( file ); //open the files one at a time to get individual return codes.
		}
	}
	else
	{	
		
		var fileArray = incopy16.extractFileArray ( files );

		// Create a new BridgeTalk message for InCopy to invoke Open
		var btMessage = new BridgeTalk;
		btMessage.target = incopy16.inCopyVersionedTargetName;
		btMessage.body = "incopy16.open (" + fileArray.toSource() + ");";
		btMessage.send();
	}
}

//=======================================================
//	openAsNew([creation-options]) 
//	- Performs the equivalent of File->New. 
//		If a folder is provided, a new, untitled document should be opened with that folder as its location. 
//		If a path to a file is given, a new document should be opened with the specified name and location. 
//		The creation-options are app-specific.
//
//	return value: 
//		Boolean		True if successful
//=======================================================
incopy16.openAsNew = function () 
{
	if( BridgeTalk.appName == incopy16.inCopyTargetName )
	{
		incopy16.validateScriptVersion(); //Make sure we're using an appropriate version of the DOM

		var showingWindow = true;
		var documentPreset = null;
		
		// Check for valid creation options
		if (arguments.length > 0)
		{
			// [showingWindow]: boolean
			for (var i = 0; i < arguments.length; i++)
			{
				if (typeof(arguments[i]) == "boolean")
				{
					showingWindow = arguments[i];
					break;
				}
			}
			
			// [documentPreset]: object or string(name of preset)
			for (var i = 0; i < arguments.length; i++)
			{
				if (typeof(arguments[i]) == "string")
				{
					documentPreset = arguments[i];
					break;
				}
				if (typeof(arguments[i]) == "object" && arguments[i] instanceof documentPreset)
				{
					documentPreset = arguments[i];
					break;
				}
			}
		}

		// create the new document
		var newDocument = app.documents.add(showingWindow, documentPreset);
		if (newDocument != null)
			return true;
		else
			return false;
		
	}
	else
	{
		// Create a new BridgeTalk message for InCopy to invoke openAsNew
		var btMessage = new BridgeTalk;
		btMessage.target = incopy16.inCopyVersionedTargetName;
		btMessage.body = "incopy16.openAsNew (";
		if (arguments.length > 0)
		{
			for (var i = 0; i < arguments.length; i++)
			{
				btMessage.body += arguments[i].toSource();
			}
		}
		btMessage.body += ");";
		
		btMessage.send();
	}
}

//=======================================================
//	print( files ) 
//	- Performs the equivalent of File->Print on the requested files.
//	
//	return value
//		undefined (app.print has no return value)
//	
//	files
//		File or Array of File			files to be printed
//=======================================================
incopy16.print = function ( /*list of*/ files )
{
	if( BridgeTalk.appName == incopy16.inCopyTargetName )
	{
		incopy16.validateScriptVersion(); //Make sure we're using an appropriate version of the DOM
		
		var fileArray = incopy16.extractFileArray ( files ); 
		for ( index = 0; index < fileArray.length; ++index )
		{
			var file = fileArray[index];
			
			app.print( file, /*[printDialog]*/ false /*, [using] printerPreset */ ); //print the files one at a time?
		}
	}
	else
	{
		var fileArray = incopy16.extractFileArray ( files );

		// Create a new BridgeTalk message for InCopy to invoke Print
		var btMessage = new BridgeTalk;
		btMessage.target = incopy16.inCopyVersionedTargetName;
		btMessage.body = "incopy16.print (" + fileArray.toSource() + ");";
		btMessage.send();
	}
}

//=======================================================
//	reveal( file ) 
//	- Gives the target app focus and brings the specified document to the foreground if it is already open.
//	
//	return value
//		Boolean		true if the file was open and was successfully brought to the foreground
//=======================================================
incopy16.reveal = function ( file ) 
{
	if( BridgeTalk.appName == incopy16.inCopyTargetName )
	{
		incopy16.validateScriptVersion(); //Make sure we're using an appropriate version of the DOM

		app.activate();

		// Convert the argument into a File.
		if( typeof file == "string" )
			file = incopy16.convertPathStrToFile( file );
		
		if(app.documents.length != 0)
		{
			//alert("incopy16.reveal: document count is:" + app.documents.length.toString());

			// Search the open documents to see if any of them are the one in question
			for(myCounter = 0; myCounter < app.documents.length; myCounter++)
			{
				aDocument = app.documents.item(myCounter);
				
				if (aDocument.saved)
				{
					//alert("incopy16.reveal: Document name is :" + aDocument.fullName.toString());
					if (aDocument.fullName.toString() == file.toString())
					{
						//alert("incopy16.reveal: We have a match!");
						// Activate this document
						app.activeDocument = aDocument;
						return true;
					}
				}
			}
		}
		return false;
	}
	else
	{
		if( typeof file == "string" )
			file = incopy16.convertPathStrToFile( file );

		// Create a new BridgeTalk message for InCopy to invoke reveal
		var btMessage = new BridgeTalk;
		btMessage.target = incopy16.inCopyVersionedTargetName;
		btMessage.body = "incopy16.reveal (" + file.toSource() + ");";
		btMessage.send();
	}
}

//=======================================================
//	place( files, showImportOptions ) 
//	-	Performs the equivalent of the File->Place command on the requested files. 
//		showImportOptions
//			Boolean		true if the ImportOptions dialog should be shown
//
//	return value
//		Boolean		true if the files were successfully placed
//=======================================================
incopy16.place = function ( file, showImportOptions ) 
{
	if( BridgeTalk.appName == incopy16.inCopyTargetName )
	{
		
		incopy16.validateScriptVersion(); //Make sure we're using an appropriate version of the DOM

		app.activate();	// Activate to be sure any dialogs or alerts resulting from the open can be seen by the user.
		
		if (app.documents.length == 0 )
		{
			app.documents.add();
		}
		
		var placeOK = true;
		if(app.activeDocument != undefined)
		{
			//alert("incopy16.place: has active document!");

			placeOK = app.activeDocument.selection[0].place(file);
			return placeOK;
 		}
		return false;
	}
	else
	{

		// Create a new BridgeTalk message for InCopy to invoke place
		var btMessage = new BridgeTalk;
		btMessage.target = incopy16.inCopyVersionedTargetName;
		btMessage.body = "incopy16.place (" + file.toSource() + "," + showImportOptions + ");";
		btMessage.send();
		return true;
	}
}

//=======================================================
//	executeScript( script ) 
//	- Performs an "eval" on the given script.
//
//	return value
//		Object		The value of evaling the last line of the script
//	
//	script
//		String		The script to be evaled
//=======================================================
incopy16.executeScript = function ( script )
{
	if( BridgeTalk.appName == incopy16.inCopyTargetName )
	{
		return eval( script );
	}
	else
	{
		// Create a new BridgeTalk message for InCopy to invoke executeScript
		var btMessage = new BridgeTalk;
		btMessage.target = incopy16.inCopyVersionedTargetName;
		btMessage.body = "incopy16.executeScript (" + script + ");";
		btMessage.send();
	}
}

//=======================================================
//	executeScriptFile
//=======================================================
incopy16.executeScriptFile = function ( file )
{
	if( BridgeTalk.appName == incopy16.inCopyTargetName )
	{
		if( typeof file == "string" )
			file = incopy16.convertPathStrToFile( file );

		var f = File( file );
		f.open( 'r', 'text', '' );
		var script = f.read();
		retval = eval( script );
		f.close();
		return retval;
	}
	else
	{
		if( typeof file == "string" )
			file = incopy16.convertPathStrToFile( file );

		// Create a new BridgeTalk message for InCopy to invoke executeScriptFile
		var btMessage = new BridgeTalk;
		btMessage.target = incopy16.inCopyVersionedTargetName;
		btMessage.body = "incopy16.executeScriptFile (" + file.toSource() + ");";
		btMessage.send();
	}
}

//========================================================================================================
// This routine Makes sure the ID/IC scriptDOM we're working with is set to at least the minimal level required.
incopy16.validateScriptVersion = function ()
{
	if( BridgeTalk.appName == incopy16.inCopyTargetName )
	{
		if (app.scriptPreferences.version < 16.0)
			app.scriptPreferences.version = 16.0 ; //New CC defines the 16.0 version of the DOM
	}
}

// This routine sets the argument menu node to be enabled, if InCopy is running.
incopy16.enabledIfRunning = function (menuItem)
{
	if( BridgeTalk.isRunning(incopy16.inCopyVersionedTargetName) )
		menuItem.enabled = true;
	else
		menuItem.enabled = false;
}

// This routine sets the argument menu node to be enabled if one non-container item is selected.
incopy16.singleFileSelectionEnabled = function (menuItem)
{
	menuItem.enabled = false;

	if (app.document != undefined && app.document.selectionLength == 1)
	{
		if (app.document.selections[0].container == true)	
			menuItem.enabled = false;
		else
			menuItem.enabled = true;
	}
}

incopy16.selectionEnabledIfIsInCopyDocs = function (menuItem)
{
	incopy16.selectionEnabled(menuItem);
	
	if (menuItem.enabled == false)
		return;
	
	if ( app.document == undefined ) {
		menuItem.enabled = false;
		return;
	}
	
	// Validate that the selected item is an InCopy document
	//	(compare item against valid InCopy document extensions, and type/creator
	menuItem.enabled = true;
	var sel = app.document.selections;
	for (i=0; i < sel.length; i++)
	{
		if (incopy.isInCopyDocument(sel[i]) == false)
		{
			menuItem.enabled = false;
			break;
		}
	}
}

incopy16.selectionEnabledIfIsScriptFile = function (menuItem)
{
	incopy16.singleFileSelectionEnabled(menuItem);
	
	if (menuItem.enabled == false)
		return;
	
	if ( app.document == undefined ) {
		menuItem.enabled = false;
		return;
	}
	
	// Validate that the selected item is a script file
	var scriptExtensions = ["js", "jsx"];
	menuItem.enabled = incopy16.matchesFileExtensions(app.document.selections[0], scriptExtensions);	
}

incopy16.selectionEnabledIfRunningAndIsInCopyDoc = function (menuItem)
{
	if( BridgeTalk.isRunning(incopy16.inCopyVersionedTargetName) )
		menuItem.enabled = true;
	else
		menuItem.enabled = false;
	
	if (menuItem.enabled == false)
		return;

	incopy16.singleFileSelectionEnabled(menuItem);
	
	if (menuItem.enabled == false)
		return;
	
	// Validate that the selected item is an InCopy document
	//	(compare item against valid InCopy document extensions, and type/creator

	menuItem.enabled = incopy16.isInCopyDocument(app.document.selections[0]);
}

incopy16.matchesFileExtensions = function ( aThumbnail, extensionsToMatch )
{
	// WORKAROUND: We are currently using Thumbnail.name instead of spec.name
	// (BRIDGE BUG: getting spec for managed files forces a replica download)
	var period = ".";
	var index = aThumbnail.name.toString().lastIndexOf(period);
	if (index > -1)
	{
		ext = aThumbnail.name.substring(index+1).toLowerCase();
		if (extensionsToMatch.length > 0)
		{
			for (var extIndex = 0; extIndex < extensionsToMatch.length; extIndex++ )
			{
				if (ext == extensionsToMatch[extIndex])
					return true;
			}
		}
	}
	return false;
}

incopy16.matchesMacFileType = function ( fileType, fileTypesToMatch )
{	
	if (fileTypesToMatch.length > 0 && fileType != "????" && fileType != "    " && fileType != null)
	{
		for (var i = 0; i < fileTypesToMatch.length; i++ )
		{
			if (fileType == fileTypesToMatch[i])
				return true;
		}
	}
	return false;
}

incopy16.isInCopyDocument = function ( aThumbnail )
{
	// Check file Extension (.indd)
	var inCopyDocExtensions = ["incx", "inca", "inct"];
	var inCopyDocTypes = ["ICx4", "InCA", "sCx4"]; // FIX - add new types, if any
	if (incopy16.matchesFileExtensions(aThumbnail, inCopyDocExtensions) == true)
	{
		return true;
	}
	else
	{
		// Else check file type - MacOS only
		// (BRIDGE BUG: getting spec for managed files forces a replica download)
		var aFile = aThumbnail.spec;
		if (incopy16.matchesMacFileType(aFile.type, inCopyDocTypes))
		{
			return true;
		}
	}
	return false;
}

// This routine sets the argument menu node to be enabled if something is selected.
incopy16.selectionEnabled = function (menuItem)
{
	menuItem.enabled = false;
	
	if (app.document != undefined && app.document.selectionLength > 0)
	{
		menuItem.enabled = true;
		var sel = app.document.selections;
		for (i=0; i<sel.length; i++)
		{
			if (sel[i].container == true)
			{
				menuItem.enabled = false;
				break;
			}
		}
	}
}

// This routine sets the argument menu node to be enabled if something is selected and app is running.
incopy16.selectionEnabledIfRunning = function (menuItem)
{
	menuItem.enabled = false;
	
	if( app.document != undefined && app.document.selectionLength > 0 && BridgeTalk.isRunning(incopy16.inCopyVersionedTargetName) )
	{
		menuItem.enabled = true;
		var sel = app.document.selections;
		for (i=0; i<sel.length; i++)
		{
			if (sel[i].container == true)
			{
				menuItem.enabled = false;
				break;
			}
		}
	}
}

//=========================================================================================================================
//-----------------------------------------------------------------
// This routine tries to return an array of File objects created
// from the 'files' argument. It will convert a single File object
// or a single string into an array of File objects, or it will
// convert an array of string and File objects into an array of
// file objects.
//-----------------------------------------------------------------
incopy16.extractFileArray = function (files)
{
	var fileArray = new Array;
	
	// If it isn't an array, make it a length one array.
	if (!(files instanceof Array))
		files = new Array (files);
	
	// Turn each item in the array into a File, or remove it.
	for (index = 0; index < files.length; ++index)
	{
		var file = files[index];
		
		if (file instanceof File)
			fileArray.push (file);
		else if (typeof file == 'string')
			fileArray.push (File (file));
		else
		{
			// do nothing
		}
	}
	
	return fileArray;
}

incopy16.convertPathStrToFile = function( file )
{
	return File( file );
}

incopy16.thumbNailArrayToFileArray = function (/* Array of thumbNails */ thumbNails)
{
	var files = [];

	for (var index = 0; index < thumbNails.length; index++ )
	{
		files.push(thumbNails[index].spec);
	}
	
	return files;
}

//=======================================================
//	IsAppInstalled( target, versionNumber ) 
//	- Is the specified version of an app installed.
//	
//	return value
//		boolean
//	
//	target
//		string			specifier for the app (i.e. indesign or incopy)
//	versionNumber
//		number			version number (not a string) for the app (i.e. 16.0)
//=======================================================
// 
incopy16.IsAppInstalled = function(targetName, targetVersionID)
{
	var appNameRoot = targetName+'-';	// 'indesign-' or 'incopy-'

	var thisVersionExists = false;
	
	// Is any version of "targetName" installed 
	if (BridgeTalk.getTargets (0).join ().indexOf (appNameRoot) != -1)
	{
		apps = BridgeTalk.getTargets(0);
		for( var i = 0; i < apps.length; i++ )
		{
			var appspec = apps[i];
			if( appspec.indexOf(appNameRoot) == 0 )
			{
				// Get the versionID for this 
				var versionID = appspec.substring(appspec.indexOf('-')+1)
				
				if ((versionID == targetVersionID) || (versionID.indexOf(targetVersionID) == 0))
				{
					thisVersionExists = true;
				}
			}
		}
	}

	return thisVersionExists;
}


//=====================================================================================================
// I n C o p y    T e s t    M e n u   (installed into the Bridge app to test integration)
//	Do this when the latter apps is starting up (InCopy or Bridge) and the other is running.
//=====================================================================================================

incopy16.testMenuInstalledInBridge = false;
incopy16.installTestMenuInBridge = function ()
{
	if (BridgeTalk.appName == incopy16.bridgeAppName)
	{
		if (incopy16.testMenuInstalledInBridge == true)
			return;
			
		//alert("Bridge ready to install InCopy Test menu");
		incopy16.testMenuInstalledInBridge = true;

		// Create a new menu for testing integration with InCopy, add it after the Bridge's Help menu
		incopy16.testMenu = {};
		incopy16.testMenu.menu = MenuElement.create("menu", "InC5Test", "after Help", "inCopyTestMenu", incopy16.inCopyTargetName);
	 
		// The code below inserts various menu items into the InCopyTest menu.
		incopy16.testMenu.newDocItem = MenuElement.create("command", "New InCopy Pub", "at the end of inCopyTestMenu", "new_in_incopy_test", incopy16.inCopyTargetName);
		incopy16.testMenu.newDocItem.onSelect = function () {incopy16.openAsNew ();};
 
		incopy16.testMenu.openItem = MenuElement.create("command", "Open in InCopy", "after new_in_incopy_test", "open_in_incopy_test", incopy16.inCopyTargetName);
		incopy16.testMenu.openItem.onDisplay = function () {incopy16.selectionEnabledIfIsInCopyDocs(this);};
		incopy16.testMenu.openItem.onSelect = function () {incopy16.open (incopy16.thumbNailArrayToFileArray(app.document.selections));};
	
		incopy16.testMenu.revealItem = MenuElement.create("command", "Reveal in InCopy", "after open_in_incopy_test", "reveal_in_incopy_test", incopy16.inCopyTargetName);
		incopy16.testMenu.revealItem.onDisplay = function () {incopy16.selectionEnabledIfRunningAndIsInCopyDoc(this);};
		incopy16.testMenu.revealItem.onSelect = function () {incopy16.reveal (incopy16.thumbNailArrayToFileArray(app.document.selections));};
	
		incopy16.testMenu.printItem = MenuElement.create("command", "Print in InCopy", "after reveal_in_incopy_test", "print_in_incopy_test", incopy16.inCopyTargetName);
		incopy16.testMenu.printItem.onDisplay = function () {incopy16.selectionEnabledIfIsInCopyDocs(this);};
		incopy16.testMenu.printItem.onSelect = function () {incopy16.print (incopy16.thumbNailArrayToFileArray(app.document.selections));};
	
		incopy16.testMenu.runScriptItem = MenuElement.create("command", "Run Script in InCopy", "after print_in_incopy_test", "run_incopy_script_test", incopy16.inCopyTargetName);
		incopy16.testMenu.runScriptItem.onDisplay = function () {incopy16.selectionEnabledIfIsScriptFile(this);};
		incopy16.testMenu.runScriptItem.onSelect = function () {incopy16.executeScriptFile (incopy16.thumbNailArrayToFileArray(app.document.selections));};
	
		incopy16.testMenu.activateItem = MenuElement.create("command", "Activate InCopy", "after run_incopy_script_test", "activate_incopy_test", incopy16.inCopyTargetName);
		incopy16.testMenu.activateItem.onDisplay = function () {incopy16.enabledIfRunning(this);};
		incopy16.testMenu.activateItem.onSelect = incopy16.activate;
	
		incopy16.testMenu.quitItem = MenuElement.create("command", "Quit InCopy", "after activate_incopy_test", "quit_incopy_test", incopy16.inCopyTargetName);
		incopy16.testMenu.quitItem.onDisplay = function () {incopy16.enabledIfRunning(this);};
		incopy16.testMenu.quitItem.onSelect = incopy16.quit;
	}
}

// Place the selected document in InCopy.
incopy16.placeSelectionInInCopy = function (showImportOptions)
{
	var fileArray = incopy16.thumbNailArrayToFileArray(app.document.selections);
	incopy16.place (fileArray[0], showImportOptions);
}

incopy16.selectionEnabledIfIsPlaceable = function (menuItem)
{
	if( app.document != undefined && app.document.selectionLength == 1 && app.document.selectionLength <= 50 ) {
		menuItem.enabled = true;
	}
	else {
		menuItem.enabled = false;
		return;
	}
	
	// Validate that docs are placeable
	menuItem.enabled = true;
	var sel = app.document.selections;
	for (i=0; i < sel.length; i++)
	{
		var aThumbNail = sel[i];
		
		if ( aThumbNail.container == true ) {
			// alert("This is a non-placeable container.");
			menuItem.enabled = false;
			break;
		}
	}
}

//=====================================================================================================
// Install the Place in InDesign menu items
//	Do this when the latter apps is starting up (InDesign or Bridge) and the other is running.
//     *** Bridge guidance says to to this at Bridge Startup time - don't defer til later ***
//=====================================================================================================
// Install the Place in InDesign menu items.
incopy16.placeMenuItemsInstalledInBridge = false;
incopy16.installPlaceMenuItems = function ()
{
	if (BridgeTalk.appName == incopy16.bridgeAppName)
	{
		if (incopy16.placeMenuItemsInstalledInBridge == true)
			return;
			
		// alert("Ready to install Place in InDesign menu items.");

 		incopy16.placeMenu = {};
		var menuExists = MenuElement.find("place_in_inincopy");
		if (menuExists)
			MenuElement.remove("place_in_inincopy");

		incopy16.placeMenu.placeItem = MenuElement.create("command", localize (incopy16.strings4PlaceMenu[0]), "at the end of submenu/Place", "place_in_inincopy", incopy16.inCopyTargetName);
 		incopy16.placeMenu.placeItem.onDisplay = function () {incopy16.selectionEnabledIfIsPlaceable(this);};
 		incopy16.placeMenu.placeItem.onSelect = function() {incopy16.placeSelectionInInCopy(this.shiftDown);};
		
		incopy16.placeMenuItemsInstalledInBridge = true;
		// alert("Installation of Place in InCopy menu items is done.");
	}
}

// Install menu in the bridge, but only if InDesign 16.0 is installed, and is the latest version
if (BridgeTalk.appName == incopy16.bridgeAppName)
{
	if( incopy16.IsAppInstalled(incopy16.targetName, incopy16.versionID) )
		incopy16.installPlaceMenuItems();
}

// Install menu in the bridge, but only if InCopy 16.0 is installed and is the latest version
if (incopy16.createInCTestMenuInBridgeApp == true)
{
	if (BridgeTalk.appName == incopy16.bridgeAppName)
 	{
		if( incopy16.IsAppInstalled(incopy16.targetName, incopy16.versionID) )
			incopy16.installTestMenuInBridge();
 	}
}

//=====================================================================================================
// I n D e s i g n   G e n e r i c   N a m e s p a c e
//		Do this only when this version of InCopy, 16.0, is the highest installed version
//=====================================================================================================

if( incopy16.IsAppInstalled(incopy16.targetName, incopy16.versionID) )
	incopy = incopy16;
	

//alert("Loading: incopy-16.0.jsx -- completed");
